/***********************************************************
	path.c -- convert to MS-DOS's pathname
***********************************************************/
#include <stdio.h>
#include <string.h>
#include "lh.h"

char *form_name(unsigned char *p, int i)
{
	int j, kflg;

	kflg = 0;
	for (j = 0; j < i; j++) {
		if (*p == 0) break;
		else if (kflg) kflg = 0;
		else if (iskanji(*p)) kflg = 1;
		else if (strchr("\"*+,./:;<=>?[\\]|\xff", *p) || *p <= ' ' || 
		         *p == swchar) *p = '_';
		p++;
	}
	if (kflg) p--;
	*p = '\0';
	return p;
}

void form_identifier(char *p)
{
	char *q, *r;

	q = strrchr(p, '.');
	if (q) {
		*q = '\0';
		r = form_name(p, 8);
		*r++ = '.';
		q++;
		form_name(q, 3);
		strcpy(r, q);
	} else {
		form_name(p, 8);
	}
}

void form_path(char *p)
{
	char *q, *r;

	if (*p == DELIM) p++;
	r = p;
	q = strchr(p, DELIM);
	while (q) {
		*q = '\0';
		form_identifier(p);
		r = stpcpy(r, p);
		*r++ = DELIM;
		p = q + 1;
		q = strchr(p, DELIM);
	}
	form_identifier(p);
	strcpy(r, p);
}

#ifdef DEBUG
void main(int argc, char *argv[])
{
	form_path(argv[1]);
	printf("%s\n", argv[1]);
}
#endif
